#!/bin/sh

LOG="/tmp/mdev.txt"

log () {
   echo "$$ $*" >> $LOG
}

MM_PIDFILE="/var/run/mm-connect.pid"

log "Helper '$MDEV' '$ACTION', '$DEVPATH', '$DEVTYPE', '$SUBSYSTEM', '$SEQNUM'"

if [ "$SUBSYSTEM" == "net" -o "$SUBSYSTEM" == "usbmisc" ]; then
	log "MM $MDEV $ACTION"
	mmcli --report-kernel-event="action=$ACTION,subsystem=$SUBSYSTEM,name=$MDEV"
fi

if [ -n "$ACTION" -a "$ACTION" == "add" ]; then
	if [ "$DEVTYPE" == "wwan" ]; then
		start-stop-daemon -S -b -m -p $MM_PIDFILE -x /usr/bin/mm-auto-reconnect.sh
		exit
# 		DEV=$(basename $(find /sys/${DEVPATH}/../../usbmisc/ -mindepth 1 -print -quit))
# 		if [ -e /rw/wan_apn.conf ]; then
# 			source /rw/wan_apn.conf
# 			log "Starting wwan interface ${DEV}, $APN."
#
# 			echo Y > /sys/${DEVPATH}/qmi/raw_ip
# 			ip link set dev $MDEV up
# 			sleep 2
# 			qmicli -p -d /dev/${DEV} --wds-start-network="${APN}" --client-no-release-cid >> $LOG
# 		fi

	elif [ "$DEVTYPE" == "wlan" ]; then
		if ! [ -e /rw/wpa_supplicant.conf ]; then
			cp /etc/wpa_supplicant.default /rw/wpa_supplicant.conf
		fi

		#SUFFIX=$(hexdump -n3 -e '/1 "%02x:"' /dev/urandom | sed 's/:$//')
		#NEW_MAC="00:E0:4D:${SUFFIX}"
		#log "Setting new MAC ${NEW_MAC}, for device $MDEV."
		#ip link set dev $MDEV address "$NEW_MAC"
		ip link set dev $MDEV up
		wpa_supplicant -B -c /rw/wpa_supplicant.conf -i $MDEV
# 	elif [ "$DEVTYPE" == "usbmisc" ]; then
# 		exit
	else
		exit 0
# 		ip link set dev $MDEV up
	fi

	# start DHCP
	if [ -e /var/run/udhcpc.$MDEV ]; then
		kill $(cat /var/run/udhcpc.$MDEV)
	fi
	log "Starting DHCP for $MDEV."
	udhcpc -b -i $MDEV -t 4 -T 4 -p /var/run/udhcpc.$MDEV
fi

if [ -n "$ACTION" -a "$ACTION" == "remove" ]; then
	if [ -e /var/run/udhcpc.$MDEV ]; then
		kill $(cat /var/run/udhcpc.$MDEV)
	fi

	if [ "$DEVTYPE" == "wwan" ]; then
		start-stop-daemon -K -p $MM_PIDFILE
		#pkill qmi-proxy
	fi
fi
