
attribute highp vec4 gla_vPos;
attribute highp vec2 gla_vTex;

attribute lowp vec4 gla_vGlyphColor;
attribute lowp vec4 gla_vOutlineColor;

uniform highp mat4 glu_matrix;

varying highp vec2 v_vTex;
varying lowp vec3 v_vGlyphColor;
varying lowp vec3 v_vOutlineColor;

varying lowp float v_vGlyphCenter;
varying lowp float v_vOutlineCenter;

void main() {
	v_vTex = gla_vTex;
	v_vGlyphColor = gla_vGlyphColor.bgr;
	v_vOutlineColor = gla_vOutlineColor.bgr;

	v_vGlyphCenter = gla_vGlyphColor.a;
	v_vOutlineCenter = gla_vOutlineColor.a;

	gl_Position = glu_matrix * gla_vPos;
}

