#extension GL_OES_standard_derivatives : enable

varying lowp vec4  v_vCol;
varying highp vec2 v_vTex;
uniform sampler2D glu_samplerTex;

const  mediump vec3 OutlineColor = vec3(0.9,0.9,0.9);
const  mediump vec3 GlyphColor = vec3(1.0,1.0,1.0);

const mediump vec2 ShadowOffset = vec2(0.002, 0.002);
const mediump vec3 ShadowColor = vec3(0.0, 0.0, 0.125);

const mediump float SmoothCenter = 0.55;

void main(void)
{
	mediump vec4 color = texture2D(glu_samplerTex, v_vTex);
	mediump float distance = 1.0 - color.a;
	mediump float smoothWidth = fwidth(distance);
	mediump float alpha;
	mediump vec3 rgb;


	mediump float distance2 = texture2D(glu_samplerTex,
													v_vTex + ShadowOffset).a;
	mediump float s = 1.0 - smoothstep(SmoothCenter - smoothWidth,
										  SmoothCenter + smoothWidth,
										  distance2);
	mediump float v = 1.0 - smoothstep(SmoothCenter - smoothWidth,
										  SmoothCenter + smoothWidth,
										  distance);

	// If s is 0, then we're inside the shadow;
	// if it's 1, then we're outside the shadow.
	//
	// If v is 0, then we're inside the vector;
	// if it's 1, then we're outside the vector.

	// Totally inside the vector (i.e., inside the glyph):
	if (v == 1.0) {
		rgb = GlyphColor;
		alpha = 0.0;
	}

	// On a nonshadowed vector edge:
	else if (s == 1.0 && v != 0.0) {
		rgb = GlyphColor;
		alpha = v;
	}

	// Totally inside the shadow:
	else if (s == 0.0 && v == 0.0) {
		rgb = ShadowColor;
		alpha = 0.0;
	}

	// On a shadowed vector edge:
	else if (s == 0.0) {
		rgb = mix(GlyphColor, ShadowColor, v);
		alpha = 0.0;
	}

	// On the shadow's outside edge:
	else {
		rgb = mix(GlyphColor, ShadowColor, v);
		alpha = s;
	}

	gl_FragColor = vec4(rgb, alpha);
}
