#!/bin/sh
LOG="/tmp/mdev.conf"

log () {
        echo "$$ $*" >> $LOG
}

log "Helper '$MDEV' '$ACTION', '$DEVPATH', '$DEVTYPE', '$SUBSYSTEM', '$SEQNUM'"

if [ -n "$ACTION" -a "$ACTION" == "add" ]; then
	if [ "$DEVTYPE" == "wwan" ]; then
		DEV=$(basename $(find /sys/${DEVPATH}/../../usbmisc/ -mindepth 1 -print -quit))

		if ! [ -e /rw/wan_apn.conf ]; then
			cp /etc/wan_apn.default /rw/wan_apn.conf
		fi

		. /rw/wan_apn.conf

		log "Starting wwan interface ${DEV}, $APN."
		echo Y > /sys/${DEVPATH}/qmi/raw_ip

		ip link set dev $MDEV up
		qmicli --device=/dev/${DEV} --device-open-proxy \
				--wds-start-network="${APN}" \
				--client-no-release-cid 2>&1 >> $LOG

	elif [ "$DEVTYPE" == "wlan" ]; then
		if ! [ -e /rw/wpa_supplicant.conf ]; then
			cp /etc/wpa_supplicant.default /rw/wpa_supplicant.conf
		fi

		ip link set dev $MDEV up
		wpa_supplicant -B -c /rw/wpa_supplicant.conf -iwlan0

	else
		ip link set dev $MDEV up
	fi


	# start DHCP
	if [ -e /var/run/udhcpc.$MDEV ]; then
		kill $(cat /var/run/udhcpc.$MDEV)
	fi
	log "Strarting DHCP for $MDEV."
	udhcpc -b -i $MDEV -t 6 -T 4 -p /var/run/udhcpc.$MDEV
fi

if [ -n "$ACTION" -a "$ACTION" == "remove" ]; then
	if [ -e /var/run/udhcpc.$MDEV ]; then
		kill $(cat /var/run/udhcpc.$MDEV)
	fi
	pkill qmi-proxy
fi
