#!/bin/sh

log () {
        echo "$$ $*" >> "/tmp/mdev.conf"
}

log "Automount helper '$MDEV' '$ACTION', '$DEVPATH', '$DEVTYPE', '$SUBSYSTEM', '$SEQNUM'"

if ! [ $MDEV ]; then
	log "No device $MDEV"
	exit 1
fi

if ! [ $ACTION ]; then
	ACTION=add
fi

MF=""

if [ ${ACTION} == "add" ]; then
	if [ -b /dev/${MDEV} ]; then
		if [ $(expr $MDEV : sd.*[0-9]) == ${#MDEV} ]; then
			if mountpoint /tmp/${MDEV}; then
				log "$MDEV already mounted"
			else
				log "$MDEV mounting"
				mkdir -p /tmp/${MDEV}
				mount -t vfat -o ro,noatime /dev/$MDEV /tmp/${MDEV}
				MF="/tmp/${MDEV}"
			fi
		fi
	else
		log "Device $MDEV is not block device"
		exit 2
	fi
else
	# remove
	if [ -d /tmp/${MDEV} ]; then
		umount /tmp/${MDEV}
	fi
fi
