#!/bin/sh

if ! [ $MDEV ]; then 
	echo "No device"
	exit 1
fi

if ! [ $ACTION ]; then 
	ACTION=add
fi

MF=""

if [ -b /dev/${MDEV} ]; then
	echo "Action: ${ACTION}"
	echo "Device: ${MDEV}"

	if [ ${ACTION} == "remove" ]; then
		umount /dev/${MDEV}
	 	rmdir /dev/${MDEV}
	else
		if [ $(expr $MDEV : sd.*[0-9]) == ${#MDEV} ]; then
			if mountpoint /media/${MDEV}; then
				echo "allready mounted"
			else
				echo "mounting"
				mkdir -p /media/${MDEV} 
				mount -t vfat -o ro /dev/$MDEV /media/${MDEV}
				MF="/media/${MDEV}"
			fi
		fi
	fi
else
	echo "Device $MDEV is not block device"
	exit 2
fi
